// Flipp Banner
function toggleFlip(card) {
  card.classList.toggle("is-flipped");
}
// End Flipp Banner

// Notification
const notifBox = document.getElementById("autoNotif");

const namaList = [
  "gepeng25",
  "kaka69",
  "raja27",
  "siMontok123",
  "lollii",
  "noname",
  "sunandar35",
  "sukakemem69",
  "venustarr",
  "sandi21",
  "haikal23",
  "luckySlot88",
  "rajaJP",
  "cewekSpin",
  "maskumisbeceks",
  "dickysukajilmeks",
  "febrian12345",
  "sukasusu",
  "cardosimanjuntak",
  "andikakangen",
  "ucokslot99",
  "mamakece88",
  "bangslotter",
  "raisaKocak123",
  "masJudi007",
  "omgilaSlot",
  "ayamkampus77",
  "siswantoJP",
  "kentirKing",
  "bucinMax",
  "kocakBanget21",
  "papacewek",
  "jombloTerhormat",
  "cewekKampung02",
  "mantanJP",
  "susanJP88",
  "anakMama99",
  "udinTopup300K",
  "bangDoyanSpin",
  "bambangTumbang",
  "srigalaMalam",
  "tokekGanas",
  "burungRajin",
  "nasigoreng88",
  "tirtaSlayer",
  "gaulAbis21",
  "pemburuJP",
  "setanCredit",
  "cewekBetina123",
  "lindaAutoMenang",
  "jefriTembak88",
  "kakekSugiono12",
  "anakSultan21",
  "tukangSpin",
  "ratuRTP",
  "bangJackpot",
  "mamaGacor",
  "raisaGoyang",
  "bebekNgegas",
  "otongMainSlot",
  "jajaSantuy",
  "dimasAutoWD",
  "nonaKalah",
  "omJPterus",
  "nonameUser777",
  "pajeroSpin",
  "sandyLovers",
  "anakWarung88",
  "slotHunterX",
  "gendutSloter",
  "yayanMainTerus",
  "abgSpin99",
  "papaMudaJP",
  "mbokIrahMenang",
  "jackyAutoBuy",
  "mancingJP",
  "kancilKocak",
  "lempengMenang",
  "bangJagoSpin",
  "userBaru21",
  "spinkuLegend",
  "mbakTante",
  "maskulin88",
  "gembelTajir",
  "babyslot123",
  "topupMania",
  "abangSerius",
  "sukasukaku99",
  "hackerSlot",
  "adminGacor",
  "komengMainJP",
  "doipunyaRTP",
  "anakRTp",
  "gachaAbis",
  "nasibJackpot",
  "bagongSpin",
  "babyGirlJP",
  "papaGoyang",
  "omTajir88",
  "cewekAsliGacor",
];

const nominalList = [
  100000, 150000, 200000, 250000, 300000, 350000, 400000, 450000, 500000,
  550000, 600000, 650000, 700000, 750000, 800000, 850000, 900000, 940000,
  1000000, 1100000, 1200000, 1300000, 1400000, 1500000, 1600000, 1700000,
  1800000, 1900000, 2000000, 2200000, 2400000, 2600000, 2800000, 3000000,
  3500000, 4000000, 4500000, 5000000, 5500000, 6000000, 6500000, 7000000,
  7500000, 8000000, 8500000, 9000000, 9500000, 10000000,
];

function formatRupiah(angka) {
  return "Rp. " + angka.toLocaleString("id-ID");
}

function showRandomNotif() {
  const nama = namaList[Math.floor(Math.random() * namaList.length)];
  const nominal = nominalList[Math.floor(Math.random() * nominalList.length)];
  notifBox.innerHTML = `<i class="lni lni-bullhorn"> Selamat </i> ${nama} baru saja mendapatkan Jackpot sebesar <strong>${formatRupiah(
    nominal
  )}</strong>`;

  notifBox.classList.add("show");

  // Sembunyikan setelah 4 detik
  setTimeout(() => {
    notifBox.classList.remove("show");
  }, 4000);
}

// Tampilkan notifikasi pertama kali setelah 1 detik
setTimeout(showRandomNotif, 3000);

// Tampilkan setiap 10 detik
setInterval(showRandomNotif, 10000);
// === End Notification === //

// === Search Engine === //
let page = 1; // halaman pertama
let isLoading = false; // flag untuk mencegah pengambilan data ganda

const searchInput = document.getElementById('searchInput');
const searchResults = document.getElementById('searchResults');
const loadingIndicator = document.getElementById('loading');

// Fungsi untuk mengambil data dari API
async function fetchSearchResults(query, page) {
  const response = await fetch(`https://api.example.com/search?q=${query}&page=${page}`);
  const data = await response.json();
  return data;
}

// Fungsi untuk menampilkan hasil pencarian
function displayResults(results) {
  results.forEach(result => {
    const li = document.createElement('li');
    li.classList.add('result-item');
    li.textContent = result.name;
    searchResults.appendChild(li);
  });
}

// Fungsi untuk menangani pencarian berdasarkan input
const express = require('express');
const app = express();

const data = [
  { name: "Permainan 1" }, 
  { name: "Permainan 2" },
  { name: "Permainan 3" },
  { name: "Permainan 4" },
  { name: "Permainan 5" },
  { name: "Permainan 6" },
  { name: "Permainan 7" },
  { name: "Permainan 8" },
  // Tambahkan lebih banyak data untuk simulasi
];

app.get('/search', (req, res) => {
  const query = req.query.q.toLowerCase();
  const page = parseInt(req.query.page) || 1;
  const resultsPerPage = 3;

  const filteredResults = data.filter(item => item.name.toLowerCase().includes(query));
  const paginatedResults = filteredResults.slice((page - 1) * resultsPerPage, page * resultsPerPage);

  res.json({ results: paginatedResults });
});

app.listen(3000, () => console.log('API berjalan di http://localhost:3000'));
