// Banner Slider
function toggleFlip(card) {
  card.classList.toggle("is-flipped");
}

// Notification
const notifBox = document.getElementById("autoNotif");

const namaList = [
  "gepeng25",
  "kaka69",
  "raja27",
  "siMontok123",
  "lollii",
  "noname",
  "sunandar35",
  "sukakemem69",
  "venustarr",
  "sandi21",
  "haikal23",
  "luckySlot88",
  "rajaJP",
  "cewekSpin",
  "maskumisbeceks",
  "dickysukajilmeks",
  "febrian12345",
  "sukasusu",
  "cardosimanjuntak",
  "andikakangen",
  "budi_gacor99",
  "ucokSlayer77",
  "ajiJPdewa",
  "rina_cantik88",
  "om_herman12",
  "mamatSpinx",
  "ucilSantuy",
  "jojoMaxwin",
  "ipul_ngacir",
  "fitriSlotQ",
  "bangOpick",
  "julianHot",
  "lalaQueen",
  "joko_manis",
  "rendyAutoJP",
  "citra69",
  "dedenSpinX",
  "fikriSloter",
  "milaCantik21",
  "alexHunter",
  "yaniMaxWin",
  "agus_diamond",
  "dewiJPmerah",
  "petrus_vip",
  "bagusKiller99",
  "nanaPemenang",
  "joniMaju88",
  "cintaSloter",
  "rafi_123",
  "delvi_max",
  "deniCuan",
  "akmalhitman",
  "dinaSlay",
  "andi_turbo77",
  "cikoSpinBae",
  "rahmat_999",
  "laraSlotGirl",
  "rakaNgaceng",
  "jessyLover",
  "pakDausHot",
  "vega777",
  "fahri_gokil",
  "tegarJP",
  "wildaManja",
  "andikaBoom",
  "nilaSlotx",
  "bambangLegend",
  "SiToba",
];

const nominalList = [
  500000, 750000, 940000, 3000000, 1000000, 550000, 8000000, 500000, 1500000,
  200000, 750000, 940000, 3000000, 2000000, 5000000, 550000, 8000000, 1000000,
  200000, 1500000, 1200000, 1800000, 670000, 920000, 2500000, 3900000, 770000,
  8300000, 1250000, 990000, 280000, 620000, 4800000, 2000000, 10000000, 600000,
  350000, 4200000, 880000, 910000, 150000, 3300000, 1900000, 230000, 370000,
  460000, 510000, 570000, 6200000, 7200000, 8100000, 970000, 1100000, 1300000
];

function formatRupiah(angka) {
  return "Rp. " + angka.toLocaleString("id-ID");
}

function showRandomNotif() {
  const nama = namaList[Math.floor(Math.random() * namaList.length)];
  const nominal = nominalList[Math.floor(Math.random() * nominalList.length)];
  notifBox.innerHTML = `<i class="lni lni-bullhorn"> Selamat </i> ${nama} baru saja withdraw sebesar <strong>${formatRupiah(
    nominal
  )}</strong>`;

  notifBox.classList.add("show");

  // Sembunyikan setelah 4 detik
  setTimeout(() => {
    notifBox.classList.remove("show");
  }, 4000);
}

// Tampilkan notifikasi pertama kali setelah 1 detik
setTimeout(showRandomNotif, 3000);

// Tampilkan setiap 10 detik
setInterval(showRandomNotif, 10000);
// === End Notification ===

// ===== Change Time RTP =====//
/* -------------------- KONFIG TESTING -------------------- */
const PERIOD_MS = 21600000; // ⏱ ganti tiap 5 detik
const STORE_KEY = "slotCard-state-test";
const BASE_EPOCH = Date.now(); // titik awal sekarang

const jamGacorList = [
  "00:00 - 02:00",
  "02:00 - 04:00",
  "04:00 - 06:00",
  "06:00 - 08:00",
  "08:00 - 10:00",
  "10:00 - 12:00",
  "12:00 - 14:00",
  "14:00 - 16:00",
  "16:00 - 18:00",
  "18:00 - 20:00",
  "20:00 - 22:00",
  "22:00 - 00:00",
];

/* -------------------- UTIL -------------------- */
const qsAll = (sel) => [...document.querySelectorAll(sel)];
const pick = (arr) => arr[Math.floor(Math.random() * arr.length)];
const randPct = () =>
  Math.random() < 0.8
    ? Math.floor(70 + Math.random() * 30)
    : Math.floor(40 + Math.random() * 30);

const periodStart = (t) =>
  BASE_EPOCH + Math.floor((t - BASE_EPOCH) / PERIOD_MS) * PERIOD_MS;

/* -------------------- LOGIKA -------------------- */
function render(state) {
  const cards = qsAll(".slot-card");
  cards.forEach((c, i) => {
    const jamT = c.querySelector(".jamGacorText");
    const bar = c.querySelector(".progress-bar-striped, .auto-progress-bar");

    if (!state[i]) state[i] = { jam: pick(jamGacorList), pct: randPct() };
    if (jamT) jamT.textContent = state[i].jam;

    if (bar) {
      const v = state[i].pct;
      bar.style.width = v + "%";
      bar.setAttribute("aria-valuenow", v);
      bar.textContent = v + "%";
      bar.classList.toggle("bg-success", v >= 70);
      bar.classList.toggle("bg-warning", v < 70);
    }
  });
  if (state.length > cards.length) state.splice(cards.length);
}

function buildState() {
  return qsAll(".slot-card").map(() => ({
    jam: pick(jamGacorList),
    pct: randPct(),
  }));
}

function save(ts, st) {
  localStorage.setItem(STORE_KEY, JSON.stringify({ p: ts, s: st }));
}

function load() {
  return JSON.parse(localStorage.getItem(STORE_KEY) || "null");
}

/* -------------------- TICK -------------------- */
function heartbeat() {
  const now = Date.now();
  let data = load();

  if (!data || now >= data.p + PERIOD_MS) {
    data = { p: periodStart(now), s: buildState() };
    save(data.p, data.s);
  }
  render(data.s);
  setTimeout(heartbeat, 1000); // cek setiap detik
}

document.addEventListener("DOMContentLoaded", heartbeat);
// ===== End Change Time RTP ===== //

// ===== Navbar Footer =====
let lastScrollTop = 0;
const bottomNav = document.getElementById("bottomNav");

window.addEventListener(
  "scroll",
  function () {
    let scrollTop = window.pageYOffset || document.documentElement.scrollTop;

    if (scrollTop > lastScrollTop) {
      // Scroll ke bawah -> sembunyikan navbar
      bottomNav.classList.add("hide");
    } else {
      // Scroll ke atas -> tampilkan navbar
      bottomNav.classList.remove("hide");
    }

    lastScrollTop = scrollTop <= 0 ? 0 : scrollTop;
  },
  false
);
// ===== End Navbar Footer ====== //

// ===== Date Info RTP ===== //
/* ────────────── Helper format tanggal ────────────── */
function formatDate(date) {
  // Contoh: "Sunday, June 8, 2025"
  return date.toLocaleDateString('ru-RU', {
    weekday: 'long',
    year: 'numeric',
    month: 'long',
    day: 'numeric'
  });
}

/* ────────────── Update tanggal & jadwalkan berikutnya ────────────── */
function updateRtpDate() {
  // 1) Tampilkan tanggal sekarang
  const now = new Date();
  document.getElementById('rtp-date').textContent = formatDate(now);

  // 2) Hitung selisih ms ke tengah malam berikutnya
  const tomorrow = new Date(now);
  tomorrow.setHours(24, 0, 0, 0);            // Pukul 00:00 besok
  const msUntilMidnight = tomorrow - now;

  // 3) Jadwalkan panggilan ulang tepat di tengah malam
  setTimeout(updateRtpDate, msUntilMidnight + 1000); // +1 s cadangan
}

/* ────────────── Jalankan saat DOM siap ────────────── */
document.addEventListener('DOMContentLoaded', updateRtpDate);
// ===== End Date Info RTP ===== //