// Menu
const navToggle = document.getElementById("nav-toggle");
const mobileMenu = document.getElementById("mobile-menu");

navToggle.addEventListener("click", () => {
  mobileMenu.classList.toggle("hidden");
});
// End Menu

// Flipper Banner Header
const slideCard = document.getElementById("slide-card");
const totalSlides = slideCard.children.length;
let currentIndex = 0;
const slideWidth = 600; // Sesuaikan dengan lebar slide-mu

function showNextSlide() {
  currentIndex++;

  if (currentIndex >= totalSlides) {
    // Reset posisi tanpa transisi
    slideCard.style.transition = "none";
    slideCard.style.transform = `translateX(0px)`;
    currentIndex = 0;

    // Tunggu browser render posisi reset
    requestAnimationFrame(() => {
      requestAnimationFrame(() => {
        // Aktifkan transisi dan geser ke slide berikutnya
        slideCard.style.transition = "transform 1s ease-in-out";
        currentIndex++;
        slideCard.style.transform = `translateX(-${
          currentIndex * slideWidth
        }px)`;
      });
    });
  } else {
    slideCard.style.transition = "transform 1s ease-in-out";
    slideCard.style.transform = `translateX(-${currentIndex * slideWidth}px)`;
  }
}

setInterval(showNextSlide, 4000);
// ===== End Flipper

// ===== Slot card Progress bar =====
document.addEventListener("DOMContentLoaded", () => {
  const bars = document.querySelectorAll(".progress-bar");
  bars.forEach((bar) => {
    const rtp = parseInt(bar.style.width);
    bar.style.width = "0";
    setTimeout(() => {
      bar.style.width = rtp + "%";
    }, 300);
  });
});

// ===== Navbar Animation =====
let lastScrollY = window.scrollY;
const bottomNav = document.getElementById("bottomNav");

window.addEventListener("scroll", () => {
  const currentScrollY = window.scrollY;

  if (currentScrollY > lastScrollY) {
    // Scroll ke bawah → Sembunyikan navbar
    bottomNav.classList.add("hide-bottom-nav");
  } else {
    // Scroll ke atas → Tampilkan navbar
    bottomNav.classList.remove("hide-bottom-nav");
  }

  lastScrollY = currentScrollY;
});

// ===== Divide Hide Tentang Kami =====
const toggleHeader = document.getElementById("toggle-header");
const desc = document.getElementById("desc");
const arrow = document.getElementById("arrow-icon");

toggleHeader.addEventListener("click", () => {
  desc.classList.toggle("expanded");
  arrow.classList.toggle("up");
  arrow.classList.toggle("down");

  const expanded = toggleHeader.getAttribute("aria-expanded") === "true";
  toggleHeader.setAttribute("aria-expanded", !expanded);
});

// Optional: jika ingin juga bisa klik panah, bukan cuma header
document.getElementById("arrow-container").addEventListener("click", () => {
  toggleHeader.click();
});

// ===== Animation Money Klik =====
document.getElementById("moneyImage").addEventListener("click", function (e) {
  const container = document.getElementById("money-burst-container");
  const rect = e.target.getBoundingClientRect();
  const originX = rect.left + rect.width / 2;
  const originY = rect.top + rect.height / 2;

  // Array of icons (coin + dollar)
  const icons = [
    "https://cdn-icons-png.flaticon.com/512/143/143960.png", // Gold coin
    "https://cdn-icons-png.flaticon.com/512/3135/3135715.png", // Dollar bill
  ];

  for (let i = 0; i < 25; i++) {
    const money = document.createElement("img");
    const randomIcon = icons[Math.floor(Math.random() * icons.length)];
    money.src = randomIcon;
    money.classList.add("money-piece");

    const angle = Math.random() * 2 * Math.PI;
    const distance = 100 + Math.random() * 100;
    const x = Math.cos(angle) * distance;
    const y = Math.sin(angle) * distance;

    money.style.setProperty("--x", `${x}px`);
    money.style.setProperty("--y", `${y}px`);
    money.style.left = `${originX}px`;
    money.style.top = `${originY}px`;

    container.appendChild(money);

    setTimeout(() => {
      money.remove();
    }, 1400);
  }
});
// ===== End JS ===== //

// ===== Start Title ===== //
let titleText = " Gendut188 - Slot Terbaik 2025 ";
let position = 0;

function animateTitle() {
  document.title =
    titleText.substring(position) + titleText.substring(0, position);
  position = (position + 1) % titleText.length;
  setTimeout(animateTitle, 250); // Ganti angka ini untuk kecepatan scroll
}

animateTitle();
// ===== End Title ===== //

// ===== Animation Jackpot list Name ======
